// Graph.cpp: implementation of the CGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Graph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CGraph::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SDK.BK] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8 + 1, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10 + 1, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CGraph::CGraph()
{
//	SC_DEBUG( "CGraph::CGraph()" );

	m_pCommonMediaFilter = NULL;
	
	m_pCommonMediaEventEx = NULL;
	
	m_pCommonMediaControl = NULL;
	
	m_pCommonGraphBuilder = NULL;
	
	m_pCommonCaptureGraphBuilder2 = NULL;
}

CGraph::~CGraph()
{
//	SC_DEBUG( "CGraph::~CGraph()" );

	CGraph::CloseGraphBuilder( FALSE );
}

BOOL CGraph::CreateGraphBuilder()
{	
	if( FAILED(CoCreateInstance( CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, IID_IGraphBuilder, (VOID **)(&m_pCommonGraphBuilder) )) ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 1  CoCreateInstance(IID_IGraphBuilder) ) ERROR!!" ); 

		return FALSE;
	}
	if( NULL == m_pCommonGraphBuilder ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 1  CoCreateInstance(IID_IGraphBuilder) ) ERROR!!" ); 

		return FALSE;
	}
	if( FAILED(m_pCommonGraphBuilder->QueryInterface( IID_IMediaControl, (VOID **)(&m_pCommonMediaControl) )) ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 2  QueryInterface(IID_IMediaControl) ) ERROR!!" ); 

		return FALSE;
	}
	if( FAILED(m_pCommonGraphBuilder->QueryInterface( IID_IMediaEventEx, (VOID **)(&m_pCommonMediaEventEx) )) ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 2  QueryInterface(IID_IMediaEventEx) ) ERROR!!" ); 

		return FALSE;
	}
	if( FAILED(m_pCommonGraphBuilder->QueryInterface( IID_IMediaFilter, (VOID **)(&m_pCommonMediaFilter) )) ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 2  QueryInterface(IID_IMediaFilter) ) ERROR!!" ); 

		return FALSE;
	}
	if( FAILED(CoCreateInstance( CLSID_CaptureGraphBuilder2, NULL, CLSCTX_INPROC_SERVER, IID_ICaptureGraphBuilder2, (VOID **)(&m_pCommonCaptureGraphBuilder2) )) ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 3  CoCreateInstance(IID_ICaptureGraphBuilder2) ) ERROR!!" ); 

		return FALSE;
	}
	if( NULL == m_pCommonCaptureGraphBuilder2 ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 3  CoCreateInstance(IID_ICaptureGraphBuilder2) ) ERROR!!" ); 

		return FALSE;
	}
	if( FAILED(m_pCommonCaptureGraphBuilder2->SetFiltergraph( m_pCommonGraphBuilder )) ) {

		SC_DEBUG( "CGraph::CreateGraphBuilder( 4 ) ERROR!!" ); 

		return FALSE;
	}
//	if( FAILED(m_pCommonGraphBuilder->SetDefaultSyncSource()) ) {
//
//		SC_DEBUG( "CGraph::CreateGraphBuilder( 5 ) ERROR!!" ); 
//
//		return FALSE;
//	}
	SC_DEBUG( "CGraph::CreateGraphBuilder()" );

	return TRUE;
}

BOOL CGraph::CloseGraphBuilder( BOOL bDumpDebugMessage )
{
	if( bDumpDebugMessage ) { SC_DEBUG( "CGraph::CloseGraphBuilder()" ); }

	RELEASE( m_pCommonMediaFilter );

	RELEASE( m_pCommonMediaEventEx );

	RELEASE( m_pCommonMediaControl );

	RELEASE( m_pCommonGraphBuilder );

	RELEASE( m_pCommonCaptureGraphBuilder2 );

	return TRUE;
}

BOOL CGraph::FindFilter( const GUID * pCategoryGUID, PWSTR pwszFilterName, UINT iDevNum, IBaseFilter ** ppBaseFilter, PWSTR pwszFilterNameBuffer, ULONG nFilterNameBufferSize )
{
	ICreateDevEnum * pCreateDeviceEnum = NULL;

	IEnumMoniker *   pEnumMoniker = NULL;

	IPropertyBag *   pPropertyBag = NULL;

	IMoniker *       pMoniker = NULL;

	ULONG            nFetched = 0;
	
	USES_CONVERSION;

    if( FAILED(CoCreateInstance( CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, (VOID **)(&pCreateDeviceEnum) )) ) {

		SC_DEBUG( "CGraph::FindFilter( 1  CoCreateInstance(IID_ICreateDevEnum) ) ERROR!!" ); 

		goto EXIT_FINDDEVICEFILTER;
	}
	if( NULL == pCreateDeviceEnum ) {

		SC_DEBUG( "CGraph::FindFilter( 1  CoCreateInstance(IID_ICreateDevEnum) ) ERROR!!" ); 

		goto EXIT_FINDDEVICEFILTER;
	}
	if( FAILED(pCreateDeviceEnum->CreateClassEnumerator( *pCategoryGUID, &pEnumMoniker, 0 )) ) {

		SC_DEBUG( "CGraph::FindFilter( 2  CreateClassEnumerator() ) ERROR!!" ); 

		goto EXIT_FINDDEVICEFILTER;
	}
	if( NULL == pEnumMoniker ) {

		SC_DEBUG( "CGraph::FindFilter( 2  CreateClassEnumerator() ) ERROR!!" ); 

		goto EXIT_FINDDEVICEFILTER;
	}
	while( SUCCEEDED(pEnumMoniker->Next( 1, &pMoniker, &nFetched )) ) {

		CComVariant oComVar;

		if( NULL == pMoniker ) { break ; }

		if( FAILED(pMoniker->BindToStorage( 0, 0, IID_IPropertyBag, (VOID **)(&pPropertyBag) )) ) { RELEASE( pMoniker ); continue; }

		if( NULL == pPropertyBag ) { RELEASE( pMoniker ); continue; }

		if( FAILED(pPropertyBag->Read( L"FriendlyName", &oComVar, NULL )) ) { RELEASE( pPropertyBag ); RELEASE( pMoniker ); continue; }

		if( NULL == wcsstr( oComVar.bstrVal, pwszFilterName ) ) { RELEASE( pPropertyBag ); RELEASE( pMoniker ); continue; }

		if( oComVar.bstrVal != wcsstr( oComVar.bstrVal, pwszFilterName ) ) { RELEASE( pPropertyBag ); RELEASE( pMoniker ); continue; }

		if( 0 != iDevNum ) { RELEASE( pPropertyBag ); RELEASE( pMoniker ); iDevNum--; continue; }

		if( FAILED(pMoniker->BindToObject( 0, 0, IID_IBaseFilter, (VOID **)(ppBaseFilter) )) ) { RELEASE( pPropertyBag ); RELEASE( pMoniker ); continue; }

		StringCbCopyW( pwszFilterNameBuffer, nFilterNameBufferSize, oComVar.bstrVal );

		SC_DEBUG( "CGraph::FindFilter( \"%s\" )", W2T(oComVar.bstrVal) ); 

		RELEASE( pPropertyBag );

		RELEASE( pMoniker );
		
		RELEASE( pEnumMoniker );
		
		RELEASE( pCreateDeviceEnum );

		return TRUE;
    }
	SC_DEBUG( "CGraph::FindFilter( 3  \"%s\" ) ERROR!!", W2T(pwszFilterName) ); 

EXIT_FINDDEVICEFILTER:

	RELEASE( pPropertyBag );
	
	RELEASE( pMoniker );
	
	RELEASE( pEnumMoniker );
	
	RELEASE( pCreateDeviceEnum );

	return FALSE;
}

BOOL CGraph::AddFilter( IBaseFilter * pBaseFilter, PWSTR pwszFilterName )
{
	USES_CONVERSION;

	if( NULL == m_pCommonGraphBuilder ) { SC_DEBUG( "CGraph::AddFilter( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pCommonGraphBuilder->AddFilter( pBaseFilter, pwszFilterName )) ) { 

		SC_DEBUG( "CGraph::AddFilter( \"%s\"  2 ) ERROR!!", W2T(pwszFilterName) );

		return FALSE;
	} 
	SC_DEBUG( "CGraph::AddFilter( \"%s\" )", W2T(pwszFilterName) ); 

	return TRUE;
}

BOOL CGraph::RemoveFilter( IBaseFilter * pBaseFilter )
{
	USES_CONVERSION;

	if( NULL == m_pCommonGraphBuilder ) { SC_DEBUG( "CGraph::RemoveFilter( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pCommonGraphBuilder->RemoveFilter( pBaseFilter )) ) { 

		SC_DEBUG( "CGraph::RemoveFilter( 2 ) ERROR!!" );

		return FALSE;
	} 
	SC_DEBUG( "CGraph::RemoveFilter()" );

	return TRUE;
}

BOOL CGraph::ConnectFilters( IBaseFilter * pUpBaseFilter, IBaseFilter * pDownBaseFilter, ULONG nUperFilterPinNum )
{
	IEnumPins * pUperFilterEnumPins = NULL; 

	IEnumPins * pDownFilterEnumPins = NULL; 

	IPin	  * pUperFilterPin = NULL; 

	IPin      * pDownFilterPin = NULL; 

	FILTER_INFO oUperFilterInfo;

	FILTER_INFO oDownFilterInfo;

	PIN_INFO	oUperPinInfo;

	PIN_INFO	oDownPinInfo;

	ULONG       nFetched = 0;

	USES_CONVERSION;
	
	if( NULL == m_pCommonGraphBuilder ) { SC_DEBUG( "CGraph::ConnectFilters( 1  NULL ) ERROR!!" ); return FALSE; }

	if( NULL == pUpBaseFilter ) { SC_DEBUG( "CGraph::ConnectFilters( 1  NULL ) ERROR!!" ); return FALSE; }

	if( NULL == pDownBaseFilter ) { SC_DEBUG( "CGraph::ConnectFilters( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(pUpBaseFilter->EnumPins( &pUperFilterEnumPins )) ) {
		
		SC_DEBUG( "CGraph::ConnectFilters( 2  EnumPins ) ERROR!!" );

		goto EXIT_CONNECTFILTERS;
	} 
	if( NULL == pUperFilterEnumPins ) {
		
		SC_DEBUG( "CGraph::ConnectFilters( 2  EnumPins ) ERROR!!" );

		goto EXIT_CONNECTFILTERS;
	} 
	if( FAILED(pDownBaseFilter->EnumPins( &pDownFilterEnumPins )) ) {
		
		SC_DEBUG( "CGraph::ConnectFilters( 2  EnumPins ) ERROR!!" );

		goto EXIT_CONNECTFILTERS;
	}
	if( NULL == pDownFilterEnumPins ) {
		
		SC_DEBUG( "CGraph::ConnectFilters( 2  EnumPins ) ERROR!!" );

		goto EXIT_CONNECTFILTERS;
	} 
	if( FAILED(pUpBaseFilter->QueryFilterInfo( &oUperFilterInfo )) ) {
		
		SC_DEBUG( "CGraph::ConnectFilters( 3  QueryFilterInfo ) ERROR!!" );

		goto EXIT_CONNECTFILTERS;
	} 
	if( FAILED(pDownBaseFilter->QueryFilterInfo( &oDownFilterInfo )) ) {
		
		SC_DEBUG( "CGraph::ConnectFilters( 3  QueryFilterInfo ) ERROR!!" );

		goto EXIT_CONNECTFILTERS;
	} 

	SC_DEBUG( "CGraph::ConnectFilters( \"%s\"  \"%s\" )", W2T(oUperFilterInfo.achName), W2T(oDownFilterInfo.achName) ); 
	
	while( SUCCEEDED(pUperFilterEnumPins->Next( 1, &pUperFilterPin, &nFetched )) ) {

		if( NULL == pUperFilterPin ) { break ; }

		if( FAILED(pUperFilterPin->QueryPinInfo( &oUperPinInfo )) ) { RELEASE( pUperFilterPin ); continue; }
		
		if( PINDIR_OUTPUT != oUperPinInfo.dir ) { RELEASE( oUperPinInfo.pFilter ); RELEASE( pUperFilterPin ); continue; }

		if( nUperFilterPinNum > 0 ) { RELEASE( oUperPinInfo.pFilter ); RELEASE( pUperFilterPin ); nUperFilterPinNum--; continue ; }

		while( SUCCEEDED(pDownFilterEnumPins->Next( 1, &pDownFilterPin, &nFetched )) ) {

			if( NULL == pDownFilterPin ) { break; }

			if( FAILED(pDownFilterPin->QueryPinInfo( &oDownPinInfo )) ) { RELEASE( pDownFilterPin ); continue; }

			if( PINDIR_INPUT != oDownPinInfo.dir ) { RELEASE( oDownPinInfo.pFilter ); RELEASE( pDownFilterPin ); continue; }

			if( FAILED(m_pCommonGraphBuilder->ConnectDirect( pUperFilterPin, pDownFilterPin, NULL )) ) { RELEASE( oDownPinInfo.pFilter ); RELEASE( pDownFilterPin ); continue; }

			SC_DEBUG( "CGraph::ConnectPins( \"%s\"  \"%s\" )", W2T(oUperPinInfo.achName), W2T(oDownPinInfo.achName) ); 
			
			RELEASE( oDownPinInfo.pFilter );

			RELEASE( pDownFilterPin );

			RELEASE( oUperPinInfo.pFilter );
			
			RELEASE( pUperFilterPin );

			RELEASE( oUperFilterInfo.pGraph );

			RELEASE( oDownFilterInfo.pGraph );

			RELEASE( pUperFilterEnumPins );

			RELEASE( pDownFilterEnumPins );

			return TRUE;
		}

		RELEASE( oUperPinInfo.pFilter );

		RELEASE( pUperFilterPin );

		pDownFilterEnumPins->Reset();
	}
	SC_DEBUG( "CGraph::ConnectPins( 4  \"%s\"  \"%s\" ) ERROR!!", W2T(oUperPinInfo.achName), W2T(oDownPinInfo.achName) ); 

EXIT_CONNECTFILTERS:

	RELEASE( oUperFilterInfo.pGraph );

	RELEASE( oDownFilterInfo.pGraph );

	RELEASE( pUperFilterEnumPins );

	RELEASE( pDownFilterEnumPins );

	return FALSE;
}

BOOL CGraph::DisconnectFilters( IBaseFilter * pUpBaseFilter, IBaseFilter * pDownBaseFilter )
{
	IEnumPins * pUperFilterEnumPins = NULL; 

	IEnumPins * pDownFilterEnumPins = NULL; 

	IPin	  * pUperFilterPin = NULL; 

	IPin      * pDownFilterPin = NULL; 

	FILTER_INFO oUperFilterInfo;

	FILTER_INFO oDownFilterInfo;

	PIN_INFO	oUperPinInfo;

	PIN_INFO	oDownPinInfo;

	ULONG       nFetched = 0;

	USES_CONVERSION;
	
	if( NULL == pUpBaseFilter ) { SC_DEBUG( "CGraph::DisconnectFilters( 1  NULL ) ERROR!!" ); return FALSE; }

	if( NULL == pDownBaseFilter ) { SC_DEBUG( "CGraph::DisconnectFilters( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(pUpBaseFilter->EnumPins( &pUperFilterEnumPins )) ) {
		
		SC_DEBUG( "CGraph::DisconnectFilters( 2  EnumPins ) ERROR!!" );

		goto EXIT_DISCONNECTFILTERS;
	} 
	if( FAILED(pDownBaseFilter->EnumPins( &pDownFilterEnumPins )) ) {
		
		SC_DEBUG( "CGraph::DisconnectFilters( 2  EnumPins ) ERROR!!" );

		goto EXIT_DISCONNECTFILTERS;
	}
	if( FAILED(pUpBaseFilter->QueryFilterInfo( &oUperFilterInfo )) ) {
		
		SC_DEBUG( "CGraph::DisconnectFilters( 3  QueryFilterInfo ) ERROR!!" );

		goto EXIT_DISCONNECTFILTERS;
	} 
	if( FAILED(pDownBaseFilter->QueryFilterInfo( &oDownFilterInfo )) ) {
		
		SC_DEBUG( "CGraph::DisconnectFilters( 3  QueryFilterInfo ) ERROR!!" );

		goto EXIT_DISCONNECTFILTERS;
	} 

	SC_DEBUG( "CGraph::DisconnectFilters( \"%s\"  \"%s\" )", W2T(oUperFilterInfo.achName), W2T(oDownFilterInfo.achName) );

	while( SUCCEEDED(pUperFilterEnumPins->Next( 1, &pUperFilterPin, &nFetched )) ) {

		FILTER_INFO oConnectedToFilterInfo;

		if( NULL == pUperFilterPin ) { break; }

		if( FAILED(pUperFilterPin->QueryPinInfo( &oUperPinInfo )) ) { RELEASE( pUperFilterPin ); continue; }
		
		if( PINDIR_OUTPUT != oUperPinInfo.dir ) { RELEASE( oUperPinInfo.pFilter ); RELEASE( pUperFilterPin ); continue; }
			
		if( FAILED(pUperFilterPin->ConnectedTo( &pDownFilterPin )) ) { RELEASE( oUperPinInfo.pFilter ); RELEASE( pUperFilterPin ); continue; }

		if( FAILED(pDownFilterPin->QueryPinInfo( &oDownPinInfo )) ) { RELEASE( oUperPinInfo.pFilter ); RELEASE( pUperFilterPin ); RELEASE( pDownFilterPin ); continue; }

		if( FAILED(oDownPinInfo.pFilter->QueryFilterInfo( &oConnectedToFilterInfo )) ) { RELEASE( oUperPinInfo.pFilter ); RELEASE( oDownPinInfo.pFilter ); RELEASE( pUperFilterPin ); RELEASE( pDownFilterPin ); continue; }
		
		if( NULL != wcsstr( oDownFilterInfo.achName, oConnectedToFilterInfo.achName ) ) { 

			if( FAILED(pUperFilterPin->Disconnect()) ) { ; }

			if( FAILED(pDownFilterPin->Disconnect()) ) { ; }

			SC_DEBUG( "CGraph::DisconnectPins( \"%s\"  \"%s\" )", W2T(oUperPinInfo.achName), W2T(oDownPinInfo.achName) ); 
		}
		RELEASE( oConnectedToFilterInfo.pGraph );

		RELEASE( oUperPinInfo.pFilter );

		RELEASE( oDownPinInfo.pFilter );

		RELEASE( pUperFilterPin );

		RELEASE( pDownFilterPin );
	}
	RELEASE( oUperFilterInfo.pGraph );

	RELEASE( oDownFilterInfo.pGraph );

	RELEASE( pUperFilterEnumPins );

	RELEASE( pDownFilterEnumPins );

	return TRUE;

EXIT_DISCONNECTFILTERS:

	RELEASE( oUperFilterInfo.pGraph );

	RELEASE( oDownFilterInfo.pGraph );

	RELEASE( pUperFilterEnumPins );

	RELEASE( pDownFilterEnumPins );

	return FALSE;
}

OAFilterState CGraph::GetState()
{
	OAFilterState eState = State_Stopped;

	if( NULL == m_pCommonMediaControl ) { SC_DEBUG( "CGraph::GetState( 1  NULL ) ERROR!!" ); return State_Stopped; }

//	if( FAILED(m_pCommonMediaControl->GetState( INFINITE, &eState )) ) {

	if( FAILED(m_pCommonMediaControl->GetState( 0, &eState )) ) {

		SC_DEBUG( "CGraph::GetState( 2 ) ERROR!!" ); 
		
		return eState;
	}
//	SC_DEBUG( "CGraph::GetState()" );

	return eState;
}

BOOL CGraph::Run()
{
	if( NULL == m_pCommonMediaControl ) { SC_DEBUG( "CGraph::Run( 1  NULL ) ERROR!!" ); return FALSE; }

	HRESULT hr = m_pCommonMediaControl->Run();

	if( FAILED(m_pCommonMediaControl->Run()) ) {

		SC_DEBUG( "CGraph::Run( 2 ) ERROR!!" );

		return FALSE;
	}
	SC_DEBUG( "CGraph::Run()" ); 

	return TRUE;
}

BOOL CGraph::Pause()
{
	if( NULL == m_pCommonMediaControl ) { SC_DEBUG( "CGraph::Pause( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pCommonMediaControl->Pause()) ) {

		SC_DEBUG( "CGraph::Pause( 2 ) ERROR!!" ); 
		
		return FALSE;
	}
	SC_DEBUG( "CGraph::Pause()" );

	return TRUE;
}

BOOL CGraph::Stop()
{
	if( NULL == m_pCommonMediaControl ) { SC_DEBUG( "CGraph::Stop( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pCommonMediaControl->Stop()) ) {

		SC_DEBUG( "CGraph::Stop( 2 ) ERROR!!" ); 
		
		return FALSE;
	}
	SC_DEBUG( "CGraph::Stop()" ); 

	return TRUE;
}

BOOL CGraph::SaveGraphBuilder( PWSTR pwszFilePathName )
{
	IStorage *       pStorage = NULL;

	IStream *        pStream = NULL;

	IPersistStream * pPersistStream = NULL;

	USES_CONVERSION;

	if( NULL == m_pCommonGraphBuilder ) { SC_DEBUG( "CGraph::SaveGraphBuilder( 1  NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(StgCreateDocfile( pwszFilePathName, STGM_CREATE | STGM_TRANSACTED | STGM_READWRITE | STGM_SHARE_EXCLUSIVE, 0, &pStorage )) ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 2  IStorage ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( NULL == pStorage ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 2  IStorage ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( FAILED(pStorage->CreateStream( L"ActiveMovieGraph", STGM_WRITE | STGM_CREATE | STGM_SHARE_EXCLUSIVE, 0, 0, &pStream )) ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 3  IStream ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( NULL == pStream ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 3  IStream ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( FAILED(m_pCommonGraphBuilder->QueryInterface( IID_IPersistStream, (VOID **)(&pPersistStream) )) ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 4  IPersistStream ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( NULL == pPersistStream ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 4  IPersistStream ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( FAILED(pPersistStream->Save( pStream, TRUE )) ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 5 ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}
	if( FAILED(pStorage->Commit( STGC_DEFAULT )) ) {

		SC_DEBUG( "CGraph::SaveGraphBuilder( 6 ) ERROR!!" ); 

		goto EXIT_SAVEGRAPH;
	}

	SC_DEBUG( "CGraph::SaveGraphBuilder( \"%s\" )", W2T(pwszFilePathName) ); 

	RELEASE( pPersistStream );

	RELEASE( pStream );

	RELEASE( pStorage );

	return TRUE;

EXIT_SAVEGRAPH:

	RELEASE( pPersistStream );

	RELEASE( pStream );

	RELEASE( pStorage );

	return FALSE;
}
